package com.wiseschematics.eqfy;

import android.app.Notification;
import android.app.Notification.Action;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build.VERSION;
import android.os.Handler;
import android.os.IBinder;
import android.preference.PreferenceManager;

public class SessionService extends Service {
	//static Service SS = null;
	private SharedPreferences sp = null;
	private SharedPreferences.Editor editor = null;
	private final Handler mHandler = new Handler();
	private PackageManager pm = null;
	private EqRx1 eqRx1;
	private int notif_ID = 1;
	private int session = 0;
	static boolean SS = false;
	private boolean isStarted = false;
	@Override
	public void onCreate(){
		super.onCreate();
		//SS = this;
		SS = true;
		setService();
		sp = PreferenceManager.getDefaultSharedPreferences(getApplicationContext());
		pm = getApplicationContext().getPackageManager();
		/*
		editor = sp.edit();
		editor.putInt("seID", 0).apply();
		*/
		setBroadcast();
	}
	private void setService(){
		if(VERSION.SDK_INT>=26){
			//startForeground(1, new Notification());
			int flag = PendingIntent.FLAG_IMMUTABLE | PendingIntent.FLAG_UPDATE_CURRENT;
	    	if(VERSION.SDK_INT<23){
	    		flag = PendingIntent.FLAG_UPDATE_CURRENT;
	    	}
			NotificationManager nm = ((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE));
			String CHANNEL_ID = "CH1";
			//if(nm.getNotificationChannel(CHANNEL_ID)==null){
				NotificationChannel channel = new NotificationChannel(CHANNEL_ID, "Session Service", NotificationManager.IMPORTANCE_LOW);
				//channel.setDescription("This service performs background tasks like app auto start/close, presets selection for wired headsets and detects connection from media apps. If stopped, Eqfy will no longer perform mentioned tasks.");
				nm.createNotificationChannel(channel);
			//}
			Notification.Builder notif = new Notification.Builder(getApplicationContext(), CHANNEL_ID).setSmallIcon(R.drawable.icn_small);
			notif.setContentTitle("Eqfy").setContentText("Session Service").setSubText("Background Service")
			.setContentIntent(PendingIntent.getActivity(this, 7, new Intent(this, EQ.class), flag));
			if(VERSION.SDK_INT>30){
				notif_ID = 47;
				Intent delete = new Intent(this, remove.class);
		    	PendingIntent pDelete = PendingIntent.getBroadcast(this, 8, delete, flag);
		    	Action action1 = new Action.Builder(null, "CLOSE", pDelete).build();
		    	notif.addAction(action1);
			}
			/*
			try{
				notif.setLargeIcon(Icon.createWithResource(getApplicationContext(), R.drawable.ic_launcher));
			}catch(Exception e){
				e.printStackTrace();
			}
			*/
			//if(notif!=null){
			startForeground(notif_ID, notif.build());
			isStarted = true;
			//}
		}
	}
	@Override
	public IBinder onBind(Intent intent) {
		// TODO Auto-generated method stub
		//Toast.makeText(this, "here", Toast.LENGTH_LONG).show();
		return null;
	}
	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		setService();
		return START_STICKY;
	}
	public static class remove extends BroadcastReceiver {
	    @Override
	    public void onReceive(Context context, Intent intent) {
	    	context.stopService(new Intent(context, SessionService.class));
	    }
	}
	@Override
	public void onDestroy() {
		SS = false;
		mHandler.removeCallbacks(reRun);
		try{
			unregisterReceiver(eqRx1);
		}catch (Exception e){
			e.printStackTrace();
		}
		if(VERSION.SDK_INT>=26 && isStarted){
			stopForeground(notif_ID);
		}
		isStarted = false;
		super.onDestroy();
	}
	private void setBroadcast(){
		eqRx1 = new EqRx1();
		IntentFilter filter = new IntentFilter();
		filter.addAction("android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION");
		filter.addAction("android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION");
		filter.addAction("android.intent.action.HEADSET_PLUG");
		filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
		filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
		registerReceiver(eqRx1, filter);
	}
	public class EqRx1 extends BroadcastReceiver{
		@Override
		public void onReceive(Context context, Intent intent){
			String action = intent.getAction();
			editor = sp.edit();
			int se = 0;
			String title = null;
			if("android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION".equals(action)){
				mHandler.removeCallbacks(reRun);
				se = intent.getIntExtra("android.media.extra.AUDIO_SESSION", 0);
				if(session!=se){
					session = se;
					title = intent.getStringExtra("android.media.extra.PACKAGE_NAME");
					editor.putInt("seID", se);
					editor.putString("seTitle", title);
					editor.apply();
				}
				if(EQ.lv1==null && sp.getBoolean("isAutoStart", false)){
					if(VERSION.SDK_INT>28){
						if(!StartService.SS1){
							startForegroundService(new Intent(getApplicationContext(), StartService.class));
						}
					}else{
						startEQ(context);
					}
				}
				return;
			}else if("android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION".equals(action)){
				se = intent.getIntExtra("android.media.extra.AUDIO_SESSION", 0);
				title = intent.getStringExtra("android.media.extra.PACKAGE_NAME");
				if(session!=se){
					session = se;
					editor.putInt("seID", se);
					editor.putString("seTitle", title);
					editor.apply();
				}else {
					String appName = appName(context, title);
					if("YouTube Music".equals(appName)||"YT Music".equals(appName)){
						mHandler.postDelayed(reRun, 1000);
					}
				}
				return;
			}
			//Wired Headset
			if ("android.intent.action.HEADSET_PLUG".equals(action)){
				int state = intent.getIntExtra("state", -1);
				switch (state) {
            	case 0:
            		//Plugged Out
            		if(sp.getBoolean("isWiredAutoClose", false)){
            			if(VERSION.SDK_INT>28 && StartService.SS1){
            				stopService(new Intent(getApplicationContext(), StartService.class));
            			}else if(EQ.lv1!=null){
            				sendFinish();
            			}
            		}else if(EQ.lv1!=null && sp.getBoolean("isWiredDeselect", false)){
						int pos = sp.getInt("isWiredDeselectPos", 0);
						EQ.lv1.performItemClick(null, pos, -1);
						EQ.lv1.setSelection(pos);
					}
            		editor.putBoolean("isPlugged", false);
            		editor.apply();
                	break;
				case 1:
					//Plugged In
					if(sp.getBoolean("isWiredAutoStart", false) && EQ.lv1==null && !sp.getBoolean("isPlugged", false)){
						if(VERSION.SDK_INT>28){
							if(!StartService.SS1){
								startForegroundService(new Intent(getApplicationContext(), StartService.class));
							}
						}else{
							startEQ(context);
						}
					}else if(EQ.lv1!=null && sp.getBoolean("isWiredSelect", false)){
						int pos = sp.getInt("isWiredSelectPos", 0);
						EQ.lv1.performItemClick(null, pos, -1);
						EQ.lv1.setSelection(pos);
					}
            		editor.putBoolean("isPlugged", true);
            		editor.apply();
					break;
				}
				return;
			}
			//Bluetooth Headset
			if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)){
				if(sp.getBoolean("isBtAutoStart", false) || EQ.lv1!=null && sp.getBoolean("isBtSelect", false)){
					try {
						checkBluetooth(intent, true);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
			if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)){
				if(sp.getBoolean("isBtAutoClose", false) || EQ.lv1!=null && sp.getBoolean("isBtDeselect", false)){
					try {
						checkBluetooth(intent, false);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
		}
	}
    private void checkBluetooth(Intent intent, boolean connected) throws Exception{
		BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
        BluetoothClass bluetoothClass = device.getBluetoothClass();
    	if (bluetoothClass != null){
            // Check if device is a audio/video related device
            int deviceClass = bluetoothClass.getDeviceClass();
            if (deviceClass == BluetoothClass.Device.AUDIO_VIDEO_HANDSFREE
            		|| deviceClass == BluetoothClass.Device.AUDIO_VIDEO_WEARABLE_HEADSET
            		|| deviceClass == BluetoothClass.Device.AUDIO_VIDEO_CAR_AUDIO
            		|| deviceClass == BluetoothClass.Device.AUDIO_VIDEO_HEADPHONES
            		|| deviceClass == BluetoothClass.Device.AUDIO_VIDEO_HIFI_AUDIO
            		|| deviceClass == BluetoothClass.Device.AUDIO_VIDEO_LOUDSPEAKER
            		|| deviceClass == BluetoothClass.Device.AUDIO_VIDEO_PORTABLE_AUDIO
            		|| deviceClass == BluetoothClass.Device.AUDIO_VIDEO_UNCATEGORIZED
            		){
            	editor = sp.edit();
            	if(connected){
            		if(sp.getBoolean("isBtAutoStart", false) && EQ.lv1==null && !sp.getBoolean("isBtPlugged", false)){
            			if(VERSION.SDK_INT>28){
    						if(!StartService.SS1){
    							startForegroundService(new Intent(getApplicationContext(), StartService.class));
    						}
    					}else{
    						startEQ(SessionService.this);
    					}
					}else if(EQ.lv1!=null && sp.getBoolean("isBtSelect", false)){
						int pos = sp.getInt("isBtSelectPos", 0);
						EQ.lv1.performItemClick(null, pos, -1);
						EQ.lv1.setSelection(pos);
					}
            		editor.putBoolean("isBtPlugged", true);
            		editor.apply();
            	}else{
            		if(sp.getBoolean("isBtAutoClose", false)){
            			if(VERSION.SDK_INT>28 && StartService.SS1){
            				stopService(new Intent(getApplicationContext(), StartService.class));
            			}else if(EQ.lv1!=null){
            				sendFinish();
            			}
            		}else if(EQ.lv1!=null && sp.getBoolean("isBtDeselect", false)){
						int pos = sp.getInt("isBtDeselectPos", 0);
						EQ.lv1.performItemClick(null, pos, -1);
						EQ.lv1.setSelection(pos);
					}
            		editor.putBoolean("isBtPlugged", false);
            		editor.apply();
            	}
            }
        }
	}
    Runnable reRun = new Runnable(){
		@Override
		public void run() {
			// TODO Auto-generated method stub
			session = 0;
			editor = sp.edit();
			editor.putInt("seID", 0);
			editor.apply();
		}
    };
    private String appName(Context context, String packageName){
		try{
			return (String) pm.getApplicationLabel(pm.getApplicationInfo(packageName, 0));
		}catch(Exception e){
			return "Unknown Media";
		}
	}
    private void startEQ(Context context){
    	PackageManager pm = context.getPackageManager();
		Intent in = pm.getLaunchIntentForPackage(context.getPackageName());
		context.startActivity(in);
    }
    private void sendFinish(){
    	Intent in = new Intent("fis3ef");
    	in.setPackage(getPackageName());
		sendBroadcast(in);
		//sendBroadcast(new Intent("fis3ef"));
	}
}