package com.wiseschematics.eqfy;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.Notification.Action;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.media.audiofx.BassBoost;
import android.media.audiofx.DynamicsProcessing;
import android.media.audiofx.Equalizer;
import android.media.audiofx.LoudnessEnhancer;
import android.media.audiofx.Virtualizer;
import android.media.audiofx.DynamicsProcessing.Eq;
import android.media.audiofx.DynamicsProcessing.EqBand;
import android.os.Build;
import android.os.Build.VERSION;
import android.os.Handler;
import android.os.IBinder;
import android.preference.PreferenceManager;

public class StartService extends Service {
	//static Service SS = null;
	private SharedPreferences sp = null;
	//private SharedPreferences.Editor editor = null;
	private EqRx2 eqRx2;
	private final int notif_ID = 2;
	private final int priority = Integer.MAX_VALUE;
	private final Handler mHandler = new Handler();
	private int session = 0;
	static boolean SS1 = false;
	private boolean isStarted = false;
	private String title = null;
	private String appName = "Global Output";
	private String currTitle = "Global Output";
	private int se = 0;
	private final int num_sliders = 10;
	private Integer[] mBandsValue = new Integer[num_sliders];
	private double S1 = 2.2D;
    private double S2 = 12.0D;
    private float agLevel = 7.5f;
    private float dRange = 48.0f;
    private boolean isGainGlobal = false;
	//private boolean isBassEnhanced = false;
	private boolean isGlobal = false;
	private boolean isManualConnect = true;
	private boolean isAutoConnect = false;
	private boolean isSam = false;
	
	private DynamicsProcessing dm = null;
	private Eq deq = null;
    private EqBand dband = null;
	private Equalizer eq = null;
	private BassBoost bb = null;
	private Virtualizer vr = null;
	private LoudnessEnhancer le = null;
	@Override
	public void onCreate(){
		super.onCreate();
		//SS = this;
		SS1 = true;
		setService();
		sp = PreferenceManager.getDefaultSharedPreferences(getApplicationContext());
		/*
		editor = sp.edit();
		editor.putInt("seID", 0).apply();
		*/
		loadEq();
		setEq(true);
		setBroadcast();
		checkSession(false);
	}
	private void checkSession(boolean manual){
		if(SessionService.SS && !isGlobal){
			int se = sp.getInt("seID", 0);
			String title = sp.getString("seTitle", null);
			if(se != 0){
				this.se = se;
				this.title = title;
				appName = appName(title);
				if(isManualConnect || manual){
					try {
						connNotif(title, appName);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}else if(isAutoConnect){
					setEq(false);
					setService();
				}
			}
		}
	}
	private void loadEq(){
		switch(Integer.parseInt(sp.getString("eqIntensity", "2"))){
    	case 2:
    		S1 = 2.2D;
    		break;
    	case 3:
    		S1 = 2.1D;
    		break;
    	case 0:
    		S1 = 3.5D;
    		break;
    	case 1:
    		S1 = 2.3D;
    		break;
    	}
		switch(Integer.parseInt(sp.getString("ampIntensity", "1"))){
    	case 2:
    		agLevel = 8.5f;
    		break;
    	case 3:
    		agLevel = 10.0f;
    		break;
    	case 0:
    		agLevel = 3.0f;
    		break;
    	}
		switch(Integer.parseInt(sp.getString("bassRange", "3"))){
    	case 2:
    		dRange = 40f;
    		break;
    	case 4:
    		dRange = 60f;
    		break;
    	case 0:
    		dRange = 20f;
    		break;
    	case 1:
    		dRange = 32f;
    		break;
    	}
		isGainGlobal = sp.getBoolean("isGainGlobal", false);
    	//isBassEnhanced = sp.getBoolean("isBassEnhanced", false);
    	if(sp.getBoolean("isBandOverlap", false)){
			S2 = 20.0D;
		}
    	isGlobal = sp.getBoolean("isGlobal", false);
    	isManualConnect = sp.getBoolean("isManualConnect", true);
    	isAutoConnect = sp.getBoolean("isAutoConnect", false);
    	//Check for Samsung Devices
    	String manuf = Build.MANUFACTURER;
    	String brand = Build.BRAND;
    	if(brand.toLowerCase().contains("samsung") || manuf.toLowerCase().contains("samsung")){
    		isSam = true;
    	}
	}
	private int getFlag(){
    	if(VERSION.SDK_INT<23){
    		return PendingIntent.FLAG_UPDATE_CURRENT;
    	}else{
    		return PendingIntent.FLAG_IMMUTABLE | PendingIntent.FLAG_UPDATE_CURRENT;
    	}
	}
	private void setService(){
		if(VERSION.SDK_INT>=26){
			Intent notificationIntent = new Intent(this, EQ.class);
		    PendingIntent pendingMain = PendingIntent.getActivity(this, 2, notificationIntent, getFlag());
			Intent delete = new Intent(this, remove.class);
			//Intent bypass = new Intent(this, bypass.class);
			Intent check = new Intent(this, check.class);
			PendingIntent pDelete = PendingIntent.getBroadcast(this, 3, delete, getFlag());
			//PendingIntent pByp = PendingIntent.getBroadcast(this, 4, bypass, PendingIntent.FLAG_UPDATE_CURRENT);
			PendingIntent pCheck = PendingIntent.getBroadcast(this, 5, check, getFlag());

			NotificationManager nm = ((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE));
			String CHANNEL_ID = "CH2";
			//if(nm.getNotificationChannel(CHANNEL_ID)==null){
				NotificationChannel channel = new NotificationChannel(CHANNEL_ID, "AutoStart Service", NotificationManager.IMPORTANCE_LOW);
				//channel.setDescription("This service performs background tasks like app auto start/close, presets selection for wired headsets and detects connection from media apps. If stopped, REEQ will no longer perform mentioned tasks.");
				nm.createNotificationChannel(channel);
			//}
			Notification.Builder notif = new Notification.Builder(getApplicationContext(), CHANNEL_ID).setSmallIcon(R.drawable.icn_small)
					.setLargeIcon(Icon.createWithResource(getApplicationContext(), R.drawable.ic_launcher));
			Action action1 = new Action.Builder(null, "CLOSE", pDelete).build();
		  	//Action action2 = new Action.Builder(null, "Bypass", pByp).build();
		  	Action action3 = new Action.Builder(null, "RE-CHECK", pCheck).build();
			notif.setContentIntent(pendingMain).setContentTitle("Eqfy").addAction(action1).addAction(action3).
			setSmallIcon(R.drawable.icn_small).setLargeIcon(Icon.createWithResource(this, R.drawable.ic_launcher))
			.setContentText("Auto-Start Service").setSubText("" + currTitle);
			startForeground(notif_ID, notif.build());
			isStarted = true;
		}
	}
	public static class remove extends BroadcastReceiver {
	    @Override
	    public void onReceive(Context context, Intent intent) {
	    	context.stopService(new Intent(context, StartService.class));
	    }
	}
	public static class check extends BroadcastReceiver {
	    @Override
	    public void onReceive(Context context, Intent intent) {
	    	context.sendBroadcast(new Intent("check_eq"));
	    }
	}
	public static class connect extends BroadcastReceiver {
	    @Override
	    public void onReceive(Context context, Intent intent) {
	    	context.sendBroadcast(new Intent("connect_eq"));
	    }
	}
	private void setBroadcast(){
		eqRx2 = new EqRx2();
		IntentFilter filter = new IntentFilter();
		filter.addAction("android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION");
		filter.addAction("android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION");
		filter.addAction("connect_eq");
		filter.addAction("check_eq");
		registerReceiver(eqRx2, filter);
	}
	public class EqRx2 extends BroadcastReceiver{
		@SuppressLint("NewApi")
		@Override
		public void onReceive(Context context, Intent intent){
			if("connect_eq".equals(intent.getAction())){
				setEq(false);
		    	setService();
		    	((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE)).cancel(11);
				return;
			}else if("check_eq".equals(intent.getAction())){
				setEq(true);
				setService();
				checkSession(true);
				return;
			}
			if(isGlobal){
				return;
			}
			se = intent.getIntExtra("android.media.extra.AUDIO_SESSION", 0);
			title = intent.getStringExtra("android.media.extra.PACKAGE_NAME");
			appName = appName(title);
			if(isManualConnect){
				if (appName.equals(currTitle)) {
					if(se!=session){
						mHandler.removeCallbacks(reRun);
						setEq(false);
					}else{
						checkYT(appName, intent.getAction());
					}
				} else {
					try {
						connNotif(title, appName);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}else if(isAutoConnect){
				if(se!=session){
					mHandler.removeCallbacks(reRun);
					setEq(false);
				}else{
					checkYT(appName, intent.getAction());
				}
				setService();
			}
		}
	}
	private void checkYT(String appName, String action){
		if("YouTube Music".equals(appName)||"YT Music".equals(appName)){
			if("android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION".equals(action)){
				mHandler.postDelayed(reRun, 1000);
			}
		}
	}
	Runnable reRun = new Runnable(){
		@Override
		public void run() {
			se = 0;
			setEq(false);
		}
    };
	private void setEq(boolean global){
		eqOff();
		if(global){
    		session = 0;
    		currTitle = "Global Output";
    	}else{
    		session = se;
    		currTitle = appName;
    	}
		try {
			if(sp.getBoolean("checked", true)){
				eq = new Equalizer(priority, session);
				eq.setEnabled(true);
				for(int i=0; i<num_sliders; i++){
					int level = sp.getInt("levels2" +i, 0);
					//int eqLevel = level;
					/*
					 if(i<3 && level>0 && !isBassEnhanced){
						 level = (int) (level/1.25);
					 }
					 */
					setBandLevel(i, level);
				}
			}
		} catch (IllegalArgumentException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (UnsupportedOperationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IllegalStateException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (RuntimeException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		/*
		try {
			if(sp.getBoolean("checked2", false)){
				dband.setGain(sp.getInt("currBB", 0)*5.0f);
		        deq.setBand(0, dband);
	        	dm.setPostEqAllChannelsTo(deq);
				bb.setStrength ((short) (sp.getInt("currBB", 0)*100));
			}
		} catch (IllegalArgumentException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (UnsupportedOperationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IllegalStateException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (RuntimeException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		*/
		try {
			if(sp.getBoolean("checked3", false)){
				vr = new Virtualizer(priority, session);
				vr.setEnabled(true);
				vr.setStrength((short) (sp.getInt("currVR", 0)*100));
			}
		} catch (IllegalArgumentException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (UnsupportedOperationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IllegalStateException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (RuntimeException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		try {
			if(sp.getBoolean("checked", true)){
				int leSe = session;
				if(leSe == 0 || isGainGlobal){
					leSe = 0;
				}
				le = new LoudnessEnhancer(leSe);
				le.setEnabled(true);
	    		le.setEnabled(false);
	    		le.release();
	    		le = null;
				le = new LoudnessEnhancer(leSe);
	    		le.setEnabled(true);
	    		le.setTargetGain(sp.getInt("levels2" +10, 0));
			}
		} catch (IllegalArgumentException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (UnsupportedOperationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IllegalStateException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (RuntimeException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		try {
			boolean isAg = sp.getBoolean("checked6", true);
			if(sp.getBoolean("checked5", false) || isAg || sp.getBoolean("checked2", false)){
				if(isSam && session!=0){
					dm = new DynamicsProcessing(priority, session, null);
					dm.setEnabled(true);
				}else{
					dm = new DynamicsProcessing(priority, 0, null);
					dm.setEnabled(true);
					dm.setEnabled(false);
					dm.release();
					dm = null;
					dm = new DynamicsProcessing(priority, 0, null);
					dm.setEnabled(true);
				}
				int level = sp.getInt("currBL", 10);
				/*
				if(level>10){
    				float gain = -(1.5f*(level-10));
    				dm.setInputGainbyChannel(0, gain);
    				dm.setInputGainbyChannel(1, 0.0f);
    			}else if(level<10){
    				float gain = -(1.5f*(10-level));
    				dm.setInputGainbyChannel(1, gain);
   					dm.setInputGainbyChannel(0, 0.0f);
    			}else{
    				dm.setInputGainbyChannel(0, 0.0f);
    				dm.setInputGainbyChannel(1, 0.0f);
    			}
				*/
				if(level>10){
    				float rgain = 0.0f;
    				float offset = -(1.5f*(level-10));
    				if(isAg){
    					offset = agLevel - (0.9f*(level-10));
    					rgain = agLevel;
    				}
    				dm.setInputGainbyChannel(0, offset);
    				dm.setInputGainbyChannel(1, rgain);
    			}else if(level<10){
    				float lgain = 0.0f;
    				float offset = -(1.5f*(10-level));
    				if(isAg){
    					offset = agLevel - (0.9f*(10-level));
    					lgain = agLevel;
    				}
    				dm.setInputGainbyChannel(1, offset);
   					dm.setInputGainbyChannel(0, lgain);
    			}else{
    				float gain = 0.0f;
    				if(isAg){
    					gain = agLevel;
    				}
    				dm.setInputGainAllChannelsTo(gain);
    			}
				//Set Deep Bass
				if(sp.getBoolean("checked2", false)){
					deq = new Eq(true,true,1);
			        dband = new EqBand(true, dRange, 0.0f);
					dband.setGain(sp.getInt("currBB", 0)*3.0f);
			        deq.setBand(0, dband);
		        	dm.setPostEqAllChannelsTo(deq);
				}
			}
		} catch (IllegalArgumentException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (UnsupportedOperationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IllegalStateException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (RuntimeException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}
	private void eqOff(){
		try{
			if(eq!=null){
	    		eq.setEnabled(false);
	    		eq.release();
	    		eq = null;
	    	}
	    	if(le!=null) {
	    		le.setEnabled(false);
	    		le.release();
	    		le = null;
	    	}
	    	if(bb!=null){
	    		bb.setEnabled(false);
	    		bb.release();
	    		bb = null;
	    	}
	    	if(vr!=null){
	    		vr.setEnabled(false);
	    		vr.release();
	    		vr = null;
	    	}
	    	if(dm!=null){
	    		dm.setEnabled(false);
	    		dm.release();
	    		dm = null;
	    	}
		}catch(IllegalStateException e){
			e.printStackTrace();
		}
	}
	private void connNotif(String title, String appName) throws Exception{
		Intent connect = new Intent(this, connect.class);
		PendingIntent pConnect = PendingIntent.getBroadcast(this, 13, connect, getFlag());
	    NotificationManager nm = ((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE));
	    Notification.Builder notif;
	    //if(VERSION.SDK_INT>=26){
			//if(nm.getNotificationChannel("CH4")==null){
				NotificationChannel channel = new NotificationChannel("CH4", "Connect Notification", NotificationManager.IMPORTANCE_MAX);
				channel.setDescription("This notification shows when a media app is detected and asks user for the connection."
						+ " If disabled, it will break the manual connection of the app resulting in a limited functionality.");
				channel.setSound(null, null);
				nm.createNotificationChannel(channel);
			//}
			notif = new Notification.Builder(this, "CH4");
		//}else{
		//	notif = new Notification.Builder(EQ.this);
		//}
		//Action action1 = new Action.Builder(Icon.createWithResource(EQ.this, R.drawable.img_close), "Close", pDelete).build();
		//Action action2 = new Action.Builder(Icon.createWithResource(EQ.this, R.drawable.img_byp), "Bypass", pByp).build();
	  	Action action2 = new Action.Builder(null, "CONNECT", pConnect).build();
		notif.setContentIntent(pConnect).addAction(action2).setSmallIcon(R.drawable.icn_small);
		Drawable icon = appIcon(title);
		if(icon!=null){
			if(icon instanceof BitmapDrawable){
				notif.setLargeIcon(((BitmapDrawable)icon).getBitmap());
			}else if(icon instanceof AdaptiveIconDrawable){
				notif.setLargeIcon(getBitmap(icon));
			}
		}
		notif.setSubText(""+appName);
		notif.setContentTitle("Connect Eqfy");
		notif.setContentText("(Tap to connect)");
		//notif.setCategory(Notification.CATEGORY_RECOMMENDATION);
	    if(notif!=null){
	    	nm.notify(11, notif.build());
	    }
	}
	@Override
	public IBinder onBind(Intent intent) {
		// TODO Auto-generated method stub
		//Toast.makeText(this, "here", Toast.LENGTH_LONG).show();
		return null;
	}
	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		setService();
		return START_STICKY;
	}
	@Override
	public void onDestroy() {
		SS1 = false;
		mHandler.removeCallbacks(reRun);
		eqOff();
		try{
			unregisterReceiver(eqRx2);
		}catch (Exception e){
			e.printStackTrace();
		}
		if(VERSION.SDK_INT>=26 && isStarted){
			stopForeground(notif_ID);
		}
		isStarted = false;
		((NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE)).cancel(11);
		super.onDestroy();
	}
    private int getBandLevel(int var0) {
        if(mBandsValue != null && mBandsValue[var0] != null) {
           var0 = mBandsValue[var0].intValue();
        } else {
           var0 = 0;
        }
        return var0;
    }
    private void setBandLevel(int band, int level){
    	mBandsValue[band]=Integer.valueOf(level);
        double even_band;
        double odd_band;
        if((band + 1) % 2==0){odd_band=(double)getBandLevel(band - 1);even_band=(double)getBandLevel(band);}
        else{odd_band=(double)getBandLevel(band);even_band=(double)getBandLevel(band + 1);}
        double var8=((double)num_sliders / 2.0D - (double)band) / S2;
        double var6=1.0D-var8;
        ++var8;
        if(odd_band>0.0D){odd_band *= var8;}
        else{odd_band /= var6;}
        if(even_band>0.0D){even_band/=var8;}
        else{even_band *= var6;}
        try {
        	if(eq!=null){
        		eq.setBandLevel((short) Math.ceil((double)(band/2)),(short) Math.ceil((odd_band + even_band)/S1));
            }
		} catch (IllegalArgumentException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (UnsupportedOperationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IllegalStateException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (RuntimeException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
    }
    private String appName(String packageName){
		try{
			PackageManager pm = getApplicationContext().getPackageManager();
			return (String) pm.getApplicationLabel(pm.getApplicationInfo(packageName, 0));
		}catch(final NameNotFoundException e){
			return "Unknown Media";
		}
	}
	private Drawable appIcon(String packageName){
		try{
			PackageManager pm = getApplicationContext().getPackageManager();
			return pm.getApplicationIcon(pm.getApplicationInfo(packageName, 0));
		}catch(final NameNotFoundException e){
			return null;
		}
	}
	private Bitmap getBitmap(Drawable drawable) {
		try{
			final Bitmap bmp = Bitmap.createBitmap(drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), Bitmap.Config.ARGB_8888); 
			final Canvas canvas = new Canvas(bmp); 
			drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight()); 
			drawable.draw(canvas); 
			return bmp;
		}catch(Exception e){
			e.printStackTrace();
			return null;
		}
	}
}
